/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.IVWTaskProcessLookup;
import filenet.vw.apps.taskman.IVWTaskServiceManager;
import filenet.vw.apps.taskman.VWTaskApplication;
import filenet.vw.apps.taskman.VWTaskApplicationSettings;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskProcessLauncher;
import filenet.vw.apps.taskman.VWTaskProcessResult;
import filenet.vw.apps.taskman.VWTaskProperties;
import filenet.vw.apps.taskman.VWTaskServiceController;
import filenet.vw.apps.taskman.VWTaskServiceProperties;
import filenet.vw.apps.taskman.VWTaskThreadGroup;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWConvertTwo;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.VWEventLogHandler;
import filenet.vw.rmi.VWUnicastRemoteObject;
import filenet.vw.sysutils.VWRegistryTool;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Appender;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VWTaskServiceManager
extends VWUnicastRemoteObject
implements IVWTaskServiceManager {
    private File m_lock = null;
    private static String m_rmiServiceName;
    private static VWTaskProperties m_tmProperties;
    private static VWTaskServiceManager m_svcMgr;
    private static Logger m_logger;
    private static HashMap VALID_COMMANDS;

    public void ping() throws RemoteException {
    }

    public File getLock() throws RemoteException {
        return this.m_lock;
    }

    public void stop(File lock, boolean stopTasks) throws RemoteException {
        String method = "stop";
        m_logger.entering(m_rmiServiceName, method);
        this.validate();
        this.m_lock = lock;
        try {
            if (stopTasks) {
                m_logger.fine(m_rmiServiceName, method, "Calling VWTaskApplication.autoStop().");
                m_logger.info(m_rmiServiceName, method, new VWString("filenet.vw.apps.taskman.VWTaskServiceManager.AutostoppingTasks", "Stopping Process Task Manager tasks.").toString());
                try {
                    VWTaskApplication.autoStop();
                }
                catch (Exception ex) {
                    m_logger.log(Level.SEVERE, m_rmiServiceName, method, ex.getMessage(), ex);
                }
                m_logger.fine(m_rmiServiceName, method, "Returned from Task Manager autostop tasks.");
            }
            int port = Integer.parseInt(VWTaskServiceProperties.getInstance().getProperty("TaskServiceManager.PreviousRegistryPort"));
            VWRegistryTool.unbind(m_rmiServiceName, port);
            m_logger.fine(m_rmiServiceName, method, "VWTaskServiceManager stopped.");
            if (stopTasks) {
                m_logger.info(m_rmiServiceName, method, new VWString("filenet.vw.apps.taskman.VWTaskServiceManager.Stopped", "Stopped.").toString());
            }
            System.exit(0);
        }
        catch (Throwable ex) {
            m_logger.log(Level.SEVERE, m_rmiServiceName, method, "Exception while stopping Task Service Manager: " + ex.getLocalizedMessage(), ex);
            System.exit(1);
        }
        m_logger.exiting(m_rmiServiceName, method);
    }

    private static void doStaticInitialization() {
        try {
            m_tmProperties = VWTaskProperties.getInstance(System.getProperty("TaskManager.Properties"));
            VWTaskProperties.initSystemProperties(m_tmProperties);
            m_rmiServiceName = VWTaskServiceManager.getRMIServiceName(m_tmProperties.getProperty("TaskManager.ServiceName", null), System.getProperty("TaskManager.Properties"));
            VWTaskApplication.initializeLogging(false, m_tmProperties);
            m_logger = Logger.getLogger("filenet.vw.apps.taskman");
        }
        catch (Exception e) {
            if (m_logger != null) {
                m_logger.log(Level.SEVERE, "Exception while performing static initalization.", e);
            } else {
                e.printStackTrace();
            }
            System.exit(1);
        }
    }

    public static void main(String[] argv) {
        final String[] theArgv = argv;
        try {
            m_logger.fine(m_rmiServiceName, "main", "Service Process Locale: " + Locale.getDefault());
            Runnable serviceRunner = new Runnable(){

                public void run() {
                    block10: {
                        String method = "main";
                        File lock = null;
                        try {
                            VWCommandLineArgs args = new VWCommandLineArgs(theArgv);
                            System.setProperty("TaskManager.ServiceManagerProcess", "true");
                            if (m_tmProperties.getProperty("TaskManager.ServiceName", null) != null) {
                                System.setProperty("filenet.vw.base.logging.ServiceName", m_tmProperties.getProperty("TaskManager.ServiceName"));
                                m_logger.addHandler((Appender)new VWEventLogHandler(m_rmiServiceName));
                            }
                            if (args.isPresent("stop")) {
                                lock = VWTaskServiceController.getInstance().getLock("stop");
                                m_logger.fine(m_rmiServiceName, method, "Stopping the Task Service Manager.");
                                try {
                                    IVWTaskServiceManager sm = VWTaskServiceManager.lookupServiceManager();
                                    sm.stop(lock, true);
                                }
                                catch (UnmarshalException ex) {
                                }
                                catch (Exception ex) {
                                    m_logger.log(Level.FINE, m_rmiServiceName, method, "Exception while stopping the Task Service Manager.", ex);
                                }
                                VWTaskServiceController.getInstance().releaseLock(lock);
                                System.exit(0);
                                break block10;
                            }
                            lock = VWTaskServiceController.getInstance().getLock("start");
                            m_logger.fine(m_rmiServiceName, method, "Starting the Task Service Manager.");
                            m_svcMgr = new VWTaskServiceManager();
                            m_svcMgr.start(lock);
                            VWTaskServiceController.getInstance().releaseLock(lock);
                        }
                        catch (Throwable ex) {
                            if (lock != null) {
                                VWTaskServiceController.getInstance().releaseLock(lock);
                            }
                            if (m_logger != null) {
                                m_logger.log(Level.SEVERE, m_rmiServiceName, "main", ex.getLocalizedMessage(), ex);
                            } else {
                                ex.printStackTrace();
                            }
                            System.exit(1);
                        }
                    }
                }
            };
            Thread serviceThread = new Thread(VWTaskThreadGroup.getInstance(), serviceRunner);
            serviceThread.setName(VWTaskServiceManager.class.getName());
            serviceThread.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static IVWTaskServiceManager lookupServiceManager(VWTaskBaseNode node) throws Exception {
        String rmiServiceName = VWTaskServiceManager.getRMIServiceName(node.getServiceName(), node.getPropertyFilePath());
        return VWTaskServiceManager.lookupServiceManager(rmiServiceName, node.getPropertyFilePath());
    }

    protected static IVWTaskServiceManager lookupServiceManager() throws Exception {
        return VWTaskServiceManager.lookupServiceManager(m_rmiServiceName, System.getProperty("TaskManager.Properties"));
    }

    private static IVWTaskServiceManager lookupServiceManager(String rmiServiceName, String taskmanPropsPath) throws Exception {
        int port = Integer.parseInt(VWTaskServiceProperties.getInstance(taskmanPropsPath).getProperty("TaskServiceManager.PreviousRegistryPort"));
        m_logger.fine(rmiServiceName, "lookupServiceManager", "Looking up service manager on port " + port + ": " + rmiServiceName);
        return (IVWTaskServiceManager)LocateRegistry.getRegistry(port).lookup(rmiServiceName);
    }

    public VWTaskProcessResult exec(String command, String inputData, boolean wait) throws Exception {
        this.validate();
        command = new Util().getCommand(command);
        this.checkCommand(command);
        return VWTaskProcessLauncher.execImpl(command, inputData, wait);
    }

    public VWTaskProcessResult exec(String[] cmdArray, String inputData, boolean wait) throws Exception {
        this.validate();
        boolean validCmd = false;
        for (int i = 0; i < cmdArray.length; ++i) {
            cmdArray[i] = new Util().getCommand(cmdArray[i]);
            if (validCmd || cmdArray[i].trim().equals("") || cmdArray[i].trim().equals("nowinexec.exe")) continue;
            this.checkCommand(cmdArray[i]);
            validCmd = true;
        }
        if (!validCmd) {
            throw new AccessException("Invalid Command");
        }
        return VWTaskProcessLauncher.execImpl(cmdArray, inputData, wait);
    }

    public VWTaskProcessResult launchJavaServer(String jreBin, String[] javaArgs, String command, boolean useJavaw, String noWinExecPath, IVWTaskProcessLookup serverNode) throws Exception {
        this.validate();
        command = new Util().getCommand(command);
        this.checkCommand(command);
        return VWTaskProcessLauncher.launchJavaServerImpl(jreBin, javaArgs, command, useJavaw, noWinExecPath, serverNode);
    }

    public VWTaskProcessResult launchJavaProcess(String jreBin, String[] javaArgs, String command, boolean useJavaw, boolean wait, boolean redirectStreams) throws Exception {
        this.validate();
        command = new Util().getCommand(command);
        this.checkCommand(command);
        return VWTaskProcessLauncher.launchJavaProcessImpl(jreBin, javaArgs, command, useJavaw, wait, redirectStreams);
    }

    private VWTaskServiceManager() throws Exception {
    }

    private void start(File lock) throws Exception {
        String method = "start";
        m_logger.entering(m_rmiServiceName, method);
        this.m_lock = lock;
        try {
            IVWTaskServiceManager sm = VWTaskServiceManager.lookupServiceManager();
            sm.ping();
            sm.stop(lock, false);
        }
        catch (Exception e) {
            // empty catch block
        }
        int port = 32771;
        try {
            port = VWTaskApplicationSettings.getInstance().getApplicationRegistryPort();
        }
        catch (Exception ex) {
            m_logger.log(Level.FINE, m_rmiServiceName, method, "Error parsing port number.", ex);
        }
        VWRegistryTool.rebind(m_rmiServiceName, this, port);
        VWTaskServiceProperties.getInstance().setProperty("TaskServiceManager.PreviousRegistryPort", "" + port);
        m_logger.fine(m_rmiServiceName, method, "Calling VWTaskApplicaiton.autoStart().");
        m_logger.info(m_rmiServiceName, method, new VWString("filenet.vw.apps.taskman.VWTaskServiceManager.AutostartingTasks", "Autostarting Process Task Manager tasks.").toString());
        try {
            VWTaskApplication.autoStart();
        }
        catch (Exception ex) {
            m_logger.log(Level.SEVERE, m_rmiServiceName, method, ex.getMessage(), ex);
        }
        m_logger.fine(m_rmiServiceName, method, "Returned from Task Manager autostart tasks.");
        this.m_lock = null;
        m_logger.fine(m_rmiServiceName, method, "VWTaskServiceManager started.");
        m_logger.info(m_rmiServiceName, method, new VWString("filenet.vw.apps.taskman.VWTaskServiceManager.Started", "Started.").toString());
        m_logger.exiting(m_rmiServiceName, method);
    }

    private static String getRMIServiceName(String serviceName, String propertiesPath) throws Exception {
        if (serviceName != null) {
            return "TaskManager.ServiceManager." + serviceName;
        }
        int guid = 0;
        try {
            File file = new File(System.getProperty("TaskManager.Properties"));
            String path = file.getCanonicalPath().toUpperCase();
            for (int i = 0; i < path.length(); ++i) {
                guid += Character.getNumericValue(path.charAt(i));
            }
        }
        catch (IOException ex) {
            m_logger.log(Level.SEVERE, "Exception while contructing GUID for VWTaskServiceManager RMI service name", ex);
            throw ex;
        }
        return "TaskManager.ServiceManager." + guid;
    }

    private void validate() throws RemoteException {
        String method = "validate";
        try {
            String remoteHost = VWTaskServiceManager.getClientHost();
            InetAddress remoteHostIP = InetAddress.getByName(remoteHost);
            m_logger.finest(m_rmiServiceName, method, "Received call from host: HostName=" + remoteHost + ", IP=" + remoteHostIP.getHostAddress());
            String explicitLocalHost = null;
            try {
                VWTaskXMLHandler xmlHandler = VWTaskApplicationSettings.getInstance().getXMLHandler();
                if (xmlHandler != null) {
                    Node node = VWTaskXMLHandler.getNodeNamed(xmlHandler.getRootNode(), "Root");
                    if (node == null || node.getNodeType() != 1) {
                        return;
                    }
                    Element ele = (Element)node;
                    if (ele.getAttributeNode("LocalHost") != null) {
                        explicitLocalHost = ele.getAttribute("LocalHost");
                    }
                }
            }
            catch (Exception e) {
                m_logger.log(Level.SEVERE, m_rmiServiceName, method, "", e);
            }
            if (explicitLocalHost == null) {
                explicitLocalHost = m_tmProperties.getProperty("TaskManager.Host", null);
            }
            if (!VWTaskUtil.isLocalHost(VWTaskServiceManager.getClientHost(), explicitLocalHost)) {
                throw new AccessException("");
            }
        }
        catch (Exception ex) {
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            throw new RemoteException(ex.getLocalizedMessage(), ex);
        }
    }

    private void checkCommand(String command) throws Exception {
        int index;
        String method = "checkCommand";
        m_logger.fine(m_rmiServiceName, method, "Original command: " + command);
        String cmd = command.trim();
        if (cmd.startsWith("nowinexec.exe")) {
            cmd = cmd.substring(13, cmd.length());
            cmd = cmd.trim();
        }
        if ((index = cmd.indexOf(" ")) != -1) {
            cmd = cmd.substring(0, index);
        }
        m_logger.fine(m_rmiServiceName, method, "Command: " + cmd);
        if (!VALID_COMMANDS.containsKey(cmd)) {
            throw new AccessException(command);
        }
    }

    static {
        m_svcMgr = null;
        m_logger = null;
        VWTaskServiceManager.doStaticInitialization();
        VALID_COMMANDS = VWTaskUtil.createHashMap(new String[]{"initfnsw", "killfnsw", "fn_build", "fn_util", "nch_update", "vwdb2util", "nowinexec.exe", "vwldap", "vwcemp", "fn_pso_switch", "filenet.pa.apps.rollup.RollupApplication", "filenet.pa.main.Main", "filenet.vw.integrator.base.VWComponentManager", "filenet.rules.daemon.RulesServer", "simulator.Simulator"});
    }

    protected class Util
    extends VWConvertTwo {
        protected Util() {
        }

        protected String getKey(int id) {
            return "MIIBCTCBtAIBADBPMQswCQYDeQQGEwJV6s4fUzEQMA4GA1UECBMHRmxvcmlkYTEYMBYGA1UEChMPRXllcyBvbiBUaGUgV2ViMRQwEgYDVQQDFAt3d3cuZXR3Lm5ldDBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQCeojtjnHqg0GTxp+XZ56RaSe1iZWpumXjU6Sx7v1FdXzsY1oLOQa090Jtnu1WsQRHh0yDS+45oncjKm1zCIZAgMBAAGgADANBgkqhkiG9w0BAQQFAANBAFBj9g+NiUh8YWPrFGntgf4miUdwqUshptjJy4PjdsD*3ugy5avvuh3GPpGh2aYXIjHpJXTUBQyzxSEIINYtc";
        }

        protected String getCommand(String str) throws Exception {
            VWAuthItem dString = super.getDString(str);
            if (dString == null) {
                return null;
            }
            return dString.getName();
        }
    }
}

